class AdvancedUserRecipe1289777923(BasicNewsRecipe):
    title          = u'PC Pro'
    oldest_article = 30
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:small;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                   

    keep_only_tags = [dict(name='div',attrs={'id':'leftContent'})]
    remove_tags = [dict(name='div', attrs={'class':['articleImageBox','boxout','MainboxTitle blueStrip',
                            'emailAFriend maxMarginBottom floatRight','boxInner','paginationLeft maxMarginBottom maxMarginTop clearFix',
                             'greyBox minPadding maxMarginBottom borderBottom','boxArrow','next']}),
                   dict(name='div', attrs={'id':['userComments','socialBookmarks','reviewsTabs']}),
                   dict(name='p', attrs={'class':['quiet minMarginBottom','quiet small minMarginBottom']}),
                   dict(name='h3', attrs={'class':['h3Title noMarginTop','h3Title']}),
                   dict(name='img'),]


    feeds          = [(u'Today', u'http://feeds.pcpro.co.uk/pcpro-today?format=xml'), 
                           (u'Reviews', u'http://feeds.pcpro.co.uk/pcpro-reviews?format=xml'), 
                           (u'Blogs', u'http://feeds.pcpro.co.uk/pcpro-blogs?format=xml')]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup